<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         http://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 *
 */

// No direct access
defined('_JEXEC') or die;
jimport('joomla.filesystem.file');
jimport('joomla.filesystem.folder');

/**
 * Content component helper.
 *
 * @package        Joomla.Administrator
 * @subpackage    com_visforms
 * @since        1.6
 */
class VisformsAEF
{
    public static $allowfrontenddataedit = 0;
    public static $delaydoubleregistrationexists = 1;
    public static $maxsubmissions = 2;
    public static $mailattachments = 3;
    public static $vfcustommailadr = 4;
    public static $vfdataview = 5;
    public static $vfformview = 6;
    public static $searchvisformsdata = 7;
    public static $searchbar = 8;
    public static $multipageforms = 9;
    public static $customFieldTypeCalculation = 10;
    public static $bootstrap3layouts = 11;
    public static $subscription = 12;
    public static $subfiles = 13;

    public static function checkAEF($feature)
    {
        switch ($feature)
        {
            case self::$allowfrontenddataedit :
                return ((self::featureExists(JPATH_ROOT . '/components/com_visforms/views/edit/view.html.php')) || (self::featureExists(JPATH_ROOT . '/administrator/manifests/packages/pkg_vfsubscription.xml')));
            case self::$delaydoubleregistrationexists :
                return self::featureExists(JPATH_ROOT . '/plugins/visforms/vfdelaydoubleregistration/vfdelaydoubleregistration.xml');
            case self::$maxsubmissions :
                return self::featureExists(JPATH_ROOT . '/plugins/visforms/vfmaxsubmissions/vfmaxsubmissions.xml');
            case self::$mailattachments :
                return self::featureExists(JPATH_ROOT . '/plugins/visforms/vfmailattachments/vfmailattachments.xml');
            case self::$vfcustommailadr :
                return self::featureExists(JPATH_ROOT . '/plugins/visforms/vfcustommailadr/vfcustommailadr.xml');
            case self::$vfdataview :
                return self::featureExists(JPATH_ROOT . '/plugins/content/vfdataview/vfdataview.xml');
            case self::$vfformview :
                return self::featureExists(JPATH_ROOT . '/plugins/content/vfformview/vfformview.xml');
            case self::$searchvisformsdata :
                return self::featureExists(JPATH_ROOT . '/plugins/search/visformsdata/visformsdata.xml');
            case self::$searchbar :
                return ((self::featureExists(JPATH_ROOT . '/administrator/manifests/files/vfsearchbar.xml')) || (self::featureExists(JPATH_ROOT . '/administrator/manifests/packages/pkg_vfsubscription.xml')));
            case self::$multipageforms :
                return ((self::featureExists(JPATH_ROOT . '/components/com_visforms/layouts/visforms/progress/default.php')) || (self::featureExists(JPATH_ROOT . '/administrator/manifests/packages/pkg_vfsubscription.xml')));
            case self::$customFieldTypeCalculation :
                return ((self::featureExists(JPATH_ROOT . '/components/com_visforms/lib/field/calculation.php')) && ((self::featureExists(JPATH_ROOT . '/administrator/manifests/files/vfcustomfieldtypes.xml') || (self::featureExists(JPATH_ROOT . '/administrator/manifests/packages/pkg_vfsubscription.xml')))));
            case self::$bootstrap3layouts :
                return ((self::featureExists(JPATH_ROOT . '/administrator/manifests/files/vfbt3layouts.xml')) || (self::featureExists(JPATH_ROOT . '/administrator/manifests/packages/pkg_vfsubscription.xml')));
            case self::$subscription :
                return (self::featureExists(JPATH_ROOT . '/administrator/manifests/packages/pkg_vfsubscription.xml'));
            case self::$subfiles :
                return (self::featureExists(JPATH_ROOT . '/administrator/manifests/files/vfsubsfiles.xml'));
            default:
                break;
        }
    }

    public static function checkForOneAef($excludeSubscription = true)
    {
        $exist = false;
        $vars = get_class_vars('VisformsAEF');
        foreach ($vars as $name => $var)
        {
            //only check static properties
            if (isset(self::$$name))
            {
                if ($excludeSubscription && self::$$name == 12)
                {
                    continue;
                }
                if (self::checkAEF(self::$$name))
                {
                    $exist = true;
                    break;
                }
            }
        }
        return $exist;
    }

    public static function checkForAllAef($excludeSubscription = true)
    {
        $exist = true;
        $vars = get_class_vars('VisformsAEF');
        foreach ($vars as $name => $var)
        {
            if ($excludeSubscription && $var === self::$subscription)
            {
                continue;
            }
            if ($excludeSubscription && $var === self::$subfiles)
            {
                continue;
            }
            //only check static properties
            if (!(isset(self::$$name)) || (!(self::checkAEF(self::$$name))))
            {
                $exist = false;
                break;
            }
        }
        return $exist;
    }

    protected static function featureExists($file)
    {
        if (!(JFile::exists(JPath::clean($file))))
        {
            return false;
        }
        else
        {
            return true;
        }
    }

    public static function getAefList()
    {
        $list = array();
        $class = new ReflectionClass('VisformsAEF');
        $aefs = $class->getStaticProperties();
        if ((empty($aefs)) || (!is_array($aefs)))
        {
            return $list;
        }
        foreach ($aefs as $aef)
        {
            $list[$aef] = self::checkAEF($aef);
        }
        return $list;
    }

    public static function getVersion($feature)
    {
        switch ($feature)
        {
            //ToDo test and enable, commented features are not used yet
            case self::$allowfrontenddataedit :
                if (self::checkAEF(static::$subscription))
                {
                    return '1.5.4';
                }
                else
                {
                    return self::extractVersionFromXMLFile(JPATH_ROOT . '/administrator/manifests/files/vffrontedit.xml');
                }
            case self::$delaydoubleregistrationexists :
                return self::extractVersionFromXMLFile(JPATH_ROOT . '/plugins/visforms/vfdelaydoubleregistration/vfdelaydoubleregistration.xml');
            case self::$maxsubmissions :
                return self::extractVersionFromXMLFile(JPATH_ROOT . '/plugins/visforms/vfmaxsubmissions/vfmaxsubmissions.xml');
            case self::$mailattachments :
                return self::extractVersionFromXMLFile(JPATH_ROOT . '/plugins/visforms/vfmailattachments/vfmailattachments.xml');
            case self::$vfcustommailadr :
                return self::extractVersionFromXMLFile(JPATH_ROOT . '/plugins/visforms/vfcustommailadr/vfcustommailadr.xml');
            case self::$vfdataview :
                return self::extractVersionFromXMLFile(JPATH_ROOT . '/plugins/content/vfdataview/vfdataview.xml');
            case self::$vfformview :
                return self::extractVersionFromXMLFile(JPATH_ROOT . '/plugins/content/vfformview/vfformview.xml');
            case self::$searchvisformsdata :
                return self::extractVersionFromXMLFile(JPATH_ROOT . '/plugins/search/visformsdata/visformsdata.xml');
            case self::$searchbar :
                if (self::checkAEF(static::$subscription))
                {
                    return '1.0.0';
                }
                else
                {
                    return self::extractVersionFromXMLFile(JPATH_ROOT . '/administrator/manifests/files/vfsearchbar.xml');
                }
            case self::$multipageforms :
                if (self::checkAEF(static::$subscription))
                {
                    return '1.0.2';
                }
                else
                {
                    return self::extractVersionFromXMLFile(JPATH_ROOT . '/administrator/manifests/files/vfmultipageforms.xml');
                }
            case self::$customFieldTypeCalculation :
                return self::extractVersionFromXMLFile(JPATH_ROOT . '/administrator/manifests/files/vfcustomfieldtypes.xml');
            case self::$bootstrap3layouts :
                if (self::checkAEF(static::$subscription))
                {
                    return '1.0.3';
                }
                else
                {
                    return self::extractVersionFromXMLFile(JPATH_ROOT . '/administrator/manifests/files/vfbt3layouts.xml');
                }
            case self::$subscription :
                return self::extractVersionFromXMLFile(JPATH_ROOT . '/administrator/manifests/packages/pkg_vfsubscription.xml');
            case self::$subfiles :
                return self::extractVersionFromXMLFile(JPATH_ROOT . '/administrator/manifests/files/vfsubsfiles.xml');
            default:
                return false;
        }
    }
    protected static function extractVersionFromXMLFile($file)
    {
        if (!(JFile::exists(JPath::clean($file))))
        {
            return false;
        }
        else
        {
            //supress warnings
            libxml_use_internal_errors(true);
            $xml = simplexml_load_file($file);
            if ($xml === false)
            {
                return false;
            }
            return $xml->version;

        }
    }
}
