<?php

/**
 * @version    2.0
 * @package    com_tlpportfolio
 * @author     TechLabPro <mamunnu@gmail.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;
$db = JFactory::getDbo();
/**
 * portfolio Table class
 *
 * @since  1.6
 */
class TlpportfolioTableportfolio extends JTable
{
	
	/**
	 * Check if a field is unique
	 *
	 * @param   string  $field  Name of the field
	 *
	 * @return bool True if unique
	 */
	private function isUnique ($field)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
			->select($db->quoteName($field))
			->from($db->quoteName($this->_tbl))
			->where($db->quoteName($field) . ' = ' . $db->quote($this->$field))
			->where($db->quoteName('id') . ' <> ' . (int) $this->{$this->_tbl_key});

		$db->setQuery($query);
		$db->execute();

		return ($db->getNumRows() == 0) ? true : false;
	}

	/**
	 * Constructor
	 *
	 * @param   JDatabase  &$db  A database connector object
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__tlpportfolio_portfolio', 'id', $db);
	}

	/**
	 * Overloaded bind function to pre-process the params.
	 *
	 * @param   array  $array   Named array
	 * @param   mixed  $ignore  Optional array or list of parameters to ignore
	 *
	 * @return  null|string  null is operation was satisfactory, otherwise returns an error
	 *
	 * @see     JTable:bind
	 * @since   1.5
	 */
	public function bind($array, $ignore = '')
	{
		$date = JFactory::getDate();
		$task = JFactory::getApplication()->input->get('task');
	    

		// Support for alias field: alias
		if (empty($array['alias']))
		{
			if (empty($array['title']))
			{
				$array['alias'] = JFilterOutput::stringURLSafe(date('Y-m-d H:i:s'));
			}
			else
			{
				if(JFactory::getConfig()->get('unicodeslugs') == 1)
				{
					$array['alias'] = JFilterOutput::stringURLUnicodeSlug(trim($array['title']));
				}
				else
				{
					$array['alias'] = JFilterOutput::stringURLSafe(trim($array['title']));
				}
			}
		}

		$app = JFactory::getApplication();
	    	$input = $app ->input;
	    	//$componentName = $input ->get('com_tlpteam');
	    	$tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');
	    	//print_r($params);


				//Support for file field: portfolio_image
				$input = JFactory::getApplication()->input;
				$files = $input->files->get('jform');
				if(!empty($files['portfolio_image'])){
					jimport('joomla.filesystem.file');
					$file = $files['portfolio_image'];

					//Check if the server found any error.
					$fileError = $file['error'];
					$message = '';
					if($fileError > 0 && $fileError != 4) {
						switch ($fileError) {
							case 1:
								$message = JText::_( 'File size exceeds allowed by the server');
								break;
							case 2:
								$message = JText::_( 'File size exceeds allowed by the html form');
								break;
							case 3:
								$message = JText::_( 'Partial upload error');
								break;
						}
						if($message != '') {
							JError::raiseWarning(500, $message);
							return false;
						}
					}
					else if($fileError == 4){
						if(isset($array['portfolio_image_hidden'])){
							$array['portfolio_image'] = $array['portfolio_image_hidden'];
						}
					}
					else{
						$app = JFactory::getApplication();
						$tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');

						$image_small_width 		= $tlpportfolio_params->get('smallimage_width');
				    	$image_small_height 	= $tlpportfolio_params->get('smallimage_height');
						$image_medium_width 	= $tlpportfolio_params->get('mediumimage_width');
						$image_medium_height 	= $tlpportfolio_params->get('mediumimage_height');
						$image_large_width 		= $tlpportfolio_params->get('largeimage_width');
						$image_large_height 	= $tlpportfolio_params->get('largeimage_height');
				   		$image_storiage_path 	= $tlpportfolio_params->get('image_path');
						$image_storiage_folder 	= JPATH_ROOT.'/'. $image_storiage_path.'/';
						

						$folder = $image_storiage_folder;
						if(!file_exists($folder)){
							mkdir($folder, 0777, true);
						}

						jimport('joomla.filter.output');
						if ($array['id'] == 0)
							{
								$db = JFactory::getDbo();
								$query = $db->getQuery(true);

								$query->select($db->quoteName('id'))
								->from($db->quoteName('#__tlpportfolio_portfolio'))
								->order($db->quoteName('id') . ' DESC');

								$db->setQuery($query);
								$result = $db->loadResult();
								$img_name='portfolio_'.$result;
							}else{
								$img_name='portfolio_'.$array['id'];
							}		


						$image_name = $img_name.".jpg";
						$image_small = 's_'.$image_name;
						$image_medium = 'm_'.$image_name;
						$image_large = 'l_'.$image_name;
					
						self::createImage($file['tmp_name'],$image_small,$image_medium,$image_large,$image_small_width, $image_small_height, $image_medium_width, $image_medium_height, $image_large_width, $image_large_height, '', $image_storiage_folder, $file['name']);

						
						$array['portfolio_image'] = $image_name;
					}
				}
		$input = JFactory::getApplication()->input;
		$task = $input->getString('task', '');

		if (($task == 'save' || $task == 'apply') && (!JFactory::getUser()->authorise('core.edit.state', 'com_tlpportfolio') && $array['state'] == 1))
		{
			$array['state'] = 0;
		}

		if ($array['id'] == 0)
		{
			$array['created_by'] = JFactory::getUser()->id;
		}

		if (isset($array['params']) && is_array($array['params']))
		{
			$registry = new JRegistry;
			$registry->loadArray($array['params']);
			$array['params'] = (string) $registry;
		}

		if (isset($array['metadata']) && is_array($array['metadata']))
		{
			$registry = new JRegistry;
			$registry->loadArray($array['metadata']);
			$array['metadata'] = (string) $registry;
		}

		if (!JFactory::getUser()->authorise('core.admin', 'com_tlpportfolio.portfolio.' . $array['id']))
		{
			$actions         = JAccess::getActionsFromFile(
				JPATH_ADMINISTRATOR . '/components/com_tlpportfolio/access.xml',
				"/access/section[@name='portfolio']/"
			);
			$default_actions = JAccess::getAssetRules('com_tlpportfolio.portfolio.' . $array['id'])->getData();
			$array_jaccess   = array();

			foreach ($actions as $action)
			{
				$array_jaccess[$action->name] = $default_actions[$action->name];
			}

			$array['rules'] = $this->JAccessRulestoArray($array_jaccess);
		}

		// Bind the rules for ACL where supported.
		if (isset($array['rules']) && is_array($array['rules']))
		{
			$this->setRules($array['rules']);
		}

		return parent::bind($array, $ignore);
	}

	/**
	 * This function convert an array of JAccessRule objects into an rules array.
	 *
	 * @param   array  $jaccessrules  An array of JAccessRule objects.
	 *
	 * @return  array
	 */
	private function JAccessRulestoArray($jaccessrules)
	{
		$rules = array();

		foreach ($jaccessrules as $action => $jaccess)
		{
			$actions = array();

			foreach ($jaccess->getData() as $group => $allow)
			{
				$actions[$group] = ((bool) $allow);
			}

			$rules[$action] = $actions;
		}

		return $rules;
	}

	/**
	 * Overloaded check function
	 *
	 * @return bool
	 */
	public function check()
	{
		jimport('joomla.filter.output');

		// Check if alias is unique
		if (!$this->isUnique('alias'))
		{
			$this->alias .= '-' . JFilterOutput::stringURLSafe(date('Y-m-d-H:i:s'));
		}


		// If there is an ordering column and this is a new row then get the next ordering value
		if (property_exists($this, 'ordering') && $this->id == 0)
		{
			$this->ordering = self::getNextOrder();
		}

		return parent::check();
	}

	/**
	 * Method to set the publishing state for a row or list of rows in the database
	 * table.  The method respects checked out rows by other users and will attempt
	 * to checkin rows that it can after adjustments are made.
	 *
	 * @param   mixed    $pks     An optional array of primary key values to update.  If not
	 *                            set the instance property value is used.
	 * @param   integer  $state   The publishing state. eg. [0 = unpublished, 1 = published]
	 * @param   integer  $userId  The user id of the user performing the operation.
	 *
	 * @return   boolean  True on success.
	 *
	 * @since    1.0.4
	 *
	 * @throws Exception
	 */
	public function publish($pks = null, $state = 1, $userId = 0)
	{
		// Initialise variables.
		$k = $this->_tbl_key;

		// Sanitize input.
		ArrayHelper::toInteger($pks);
		$userId = (int) $userId;
		$state  = (int) $state;

		// If there are no primary keys set check to see if the instance key is set.
		if (empty($pks))
		{
			if ($this->$k)
			{
				$pks = array($this->$k);
			}
			// Nothing to set publishing state on, return false.
			else
			{
				throw new Exception(500, JText::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));
			}
		}

		// Build the WHERE clause for the primary keys.
		$where = $k . '=' . implode(' OR ' . $k . '=', $pks);

		// Determine if there is checkin support for the table.
		if (!property_exists($this, 'checked_out') || !property_exists($this, 'checked_out_time'))
		{
			$checkin = '';
		}
		else
		{
			$checkin = ' AND (checked_out = 0 OR checked_out = ' . (int) $userId . ')';
		}

		// Update the publishing state for rows with the given primary keys.
		$this->_db->setQuery(
			'UPDATE `' . $this->_tbl . '`' .
			' SET `state` = ' . (int) $state .
			' WHERE (' . $where . ')' .
			$checkin
		);
		$this->_db->execute();

		// If checkin is supported and all rows were adjusted, check them in.
		if ($checkin && (count($pks) == $this->_db->getAffectedRows()))
		{
			// Checkin each row.
			foreach ($pks as $pk)
			{
				$this->checkin($pk);
			}
		}

		// If the JTable instance value is in the list of primary keys that were set, set the instance.
		if (in_array($this->$k, $pks))
		{
			$this->state = $state;
		}

		return true;
	}

	/**
	 * Define a namespaced asset name for inclusion in the #__assets table
	 *
	 * @return string The asset name
	 *
	 * @see JTable::_getAssetName
	 */
	protected function _getAssetName()
	{
		$k = $this->_tbl_key;

		return 'com_tlpportfolio.portfolio.' . (int) $this->$k;
	}

	/**
	 * Returns the parent asset's id. If you have a tree structure, retrieve the parent's id using the external key field
	 *
	 * @param   JTable   $table  Table name
	 * @param   integer  $id     Id
	 *
	 * @see JTable::_getAssetParentId
	 *
	 * @return mixed The id on success, false on failure.
	 */
	protected function _getAssetParentId(JTable $table = null, $id = null)
	{
		// We will retrieve the parent-asset from the Asset-table
		$assetParent = JTable::getInstance('Asset');

		// Default: if no asset-parent can be found we take the global asset
		$assetParentId = $assetParent->getRootId();

		// The item has the component as asset-parent
		$assetParent->loadByName('com_tlpportfolio');

		// Return the found asset-parent-id
		if ($assetParent->id)
		{
			$assetParentId = $assetParent->id;
		}

		return $assetParentId;
	}

	/**
	 * Delete a record by id
	 *
	 * @param   mixed  $pk  Primary key value to delete. Optional
	 *
	 * @return bool
	 */
	public function delete($pk = null)
	{
		$this->load($pk);
		$result = parent::delete($pk);

		if ($result)
		{
	jimport('joomla.filesystem.file');
	$result = JFile::delete(JPATH_ADMINISTRATOR . '/components/com_tlpportfolio/images/portfolio/' . $this->portfolio_image);
		}
		return $result;
	}
/*
    * Create Thumbnail
    */
    
    public  function createImage($src_file,$small_name,$medium_name,$large_name,
                                        $max_width_s,
                                        $max_height_s,
                                        $max_width_m,
                                        $max_height_m,
                                        $max_width_l,
                                        $max_height_l,
                                        $tag,
                                        $path,
                                        $orig_name)
            {
                ini_set('memory_limit', '200M');
                
                echo $src_file = urldecode($src_file);
                //exit;
                
                    $orig_name = strtolower($orig_name);
                    $findme  = '.jpg';
                    $pos = strpos($orig_name, $findme);
                    if ($pos === false)
                    {
                        $findme  = '.jpeg';
                        $pos = strpos($orig_name, $findme);
                        if ($pos === false)
                        {
                            $findme  = '.gif';
                            $pos = strpos($orig_name, $findme);
                            if ($pos === false)
                            {
                                $findme  = '.png';
                                $pos = strpos($orig_name, $findme);
                                if ($pos === false)
                                {
                                    return;
                                }
                                else
                                {
                                    $type = "png";
                                }
                            }
                            else
                            {
                                $type = "gif";
                            }
                        }
                        else
                        {
                            $type = "jpeg";
                        }
                    }
                    else
                    {
                        $type = "jpeg";
                    }
                //}
                
                $max_small_h = $max_height_s;
                $max_small_w = $max_width_s;
                $max_medium_h = $max_height_m;
                $max_medium_w = $max_width_m;
                $max_large_h = $max_height_l;
                $max_large_w = $max_width_l;
                
                if ( file_exists( "$path/$small_name")) {
                    unlink( "$path/$small_name");
                }
                
                if ( file_exists( "$path/$medium_name")) {
                    unlink( "$path/$medium_name");
                }
                
                if ( file_exists( "$path/$large_name")) {
                    unlink( "$path/$large_name");
                }
                
                $read = 'imagecreatefrom' . $type; 
                $write = 'image' . $type; 
                
                $src_img = $read($src_file);
                
                // height/width
                $imginfo = getimagesize($src_file);
                $src_w = $imginfo[0];
                $src_h = $imginfo[1];
                
                $zoom_h = $max_small_h / $src_h;
                $zoom_w = $max_small_w / $src_w;
                $zoom   = min($zoom_h, $zoom_w);
                $dst_small_h  = $zoom<1 ? round($src_h*$zoom) : $src_h;
                $dst_small_w  = $zoom<1 ? round($src_w*$zoom) : $src_w;
                
                $zoom_h = $max_medium_h / $src_h;
                $zoom_w = $max_medium_w / $src_w;
                $zoom   = min($zoom_h, $zoom_w);
                $dst_medium_h  = $zoom<1 ? round($src_h*$zoom) : $src_h;
                $dst_medium_w  = $zoom<1 ? round($src_w*$zoom) : $src_w;
                
                $zoom_h = $max_large_h / $src_h;
                $zoom_w = $max_large_w / $src_w;
                $zoom   = min($zoom_h, $zoom_w);
                $dst_large_h  = $zoom<1 ? round($src_h*$zoom) : $src_h;
                $dst_large_w  = $zoom<1 ? round($src_w*$zoom) : $src_w;
                
                
                $dst_s_img = imagecreatetruecolor($dst_small_w,$dst_small_h);
                $white = imagecolorallocate($dst_s_img,255,255,255);
                imagefill($dst_s_img,0,0,$white);
                imagecopyresampled($dst_s_img,$src_img, 0,0,0,0, $dst_small_w,$dst_small_h,$src_w,$src_h);
                $textcolor = imagecolorallocate($dst_s_img, 255, 255, 255);
                if (isset($tag))
                    imagestring($dst_s_img, 2, 2, 2, "$tag", $textcolor);
                if($type == 'jpeg'){
                    $desc_img = $write($dst_s_img,"$path/$small_name", 75);
                }else{
                    $desc_img = $write($dst_s_img,"$path/$small_name", 2);
                }
                
                
                $dst_m_img = imagecreatetruecolor($dst_medium_w,$dst_medium_h);
                $white = imagecolorallocate($dst_m_img,255,255,255);
                imagefill($dst_m_img,0,0,$white);
                imagecopyresampled($dst_m_img,$src_img, 0,0,0,0, $dst_medium_w,$dst_medium_h,$src_w,$src_h);
                $textcolor = imagecolorallocate($dst_m_img, 255, 255, 255);
                if (isset($tag))
                    imagestring($dst_m_img, 2, 2, 2, "$tag", $textcolor);
                if($type == 'jpeg'){
                    $desc_img = $write($dst_m_img,"$path/$medium_name", 75);
                }else{
                    $desc_img = $write($dst_m_img,"$path/$medium_name", 2);
                }
                
                $dst_l_img = imagecreatetruecolor($dst_large_w,$dst_large_h);
                $white = imagecolorallocate($dst_l_img,255,255,255);
                imagefill($dst_l_img,0,0,$white);
                imagecopyresampled($dst_l_img,$src_img, 0,0,0,0, $dst_large_w,$dst_large_h,$src_w,$src_h);

                $textcolor = imagecolorallocate($dst_l_img, 255, 255, 255);
                if (isset($tag))
                    imagestring($dst_l_img, 2, 2, 2, "$tag", $textcolor);
                if($type == 'jpeg'){
                    $desc_img = $write($dst_l_img,"$path/$large_name", 75);
                }else{
                    $desc_img = $write($dst_l_img,"$path/$large_name", 2);
                }
                
                
            
            }       

}

