<?php
/**
 * @version    2.0
 * @package    com_tlpportfolio
 * @author     TechLabPro <mamunnu@gmail.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;
$app = JFactory::getApplication();
$tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');
$image_storiage_path = $tlpportfolio_params->get('image_path');
$image_grid 		 = $tlpportfolio_params->get('image_grid');
$content_grid		 = 12-$image_grid;
$image_area 		 = "tlp-col-md-".$image_grid." tlp-col-lg-".$image_grid." tlp-col-sm-6";
$content_area 		 = "tlp-col-md-".$content_grid." tlp-col-lg-".$content_grid." tlp-col-sm-6";
?>
<?php if ($this->item) : ?>

	<div class="container-fluid">
		<div class="tlp-row tlp-portfolio-detail">
			<div class="<?php echo $image_area?> image-area">
			<?php if (!empty($this->item->portfolio_image)){?>
		    	<figure>
		 			<img class="tlp-img-responsive" src="<?php echo JURI::root().$image_storiage_path.'/l_'.$this->item->portfolio_image; ?> " alt="<?php echo $this->item->title; ?>"/>		     		
		 		</figure>	
		    <?php }?>
			</div>

			<div class="<?php echo $content_area?> content-area">
			<article>
				<h3><?php echo $this->item->title; ?></h3>
				<p><?php echo $this->item->description; ?></p>
				<?php 
				if($this->item->category_title !=''){?>
				<div class="attribute"><label><?php echo JText::_('COM_TLPPORTFOLIO_FORM_LBL_PORTFOLIO_CATEGORY'); ?>:</label> <?php echo $this->item->category_title;?></div>
				<?php }
				if($this->item->client_name !=''){?>
				<div class="attribute"><label><?php echo JText::_('COM_TLPPORTFOLIO_FORM_LBL_PORTFOLIO_CLIENT_NAME'); ?>:</label> <?php echo $this->item->client_name;?></div>
				<?php }
				if($this->item->tools_used !=''){?>
				<div class="attribute"><label><?php echo JText::_('COM_TLPPORTFOLIO_FORM_LBL_PORTFOLIO_TOOLS_USED'); ?>:</label> <?php echo $this->item->tools_used;?></div>
				<?php }
				if($this->item->project_url !=''){?>
				<div class="attribute"><label><?php echo JText::_('COM_TLPPORTFOLIO_FORM_LBL_PORTFOLIO_PROJECT_URL'); ?>:</label> <a href="<?php echo $this->item->project_url;?>" target="_New"><?php echo $this->item->project_url;?></a></div>
				<?php }
				if($this->item->completed_date !=''){?>
				<div class="attribute"><label><?php echo JText::_('COM_TLPPORTFOLIO_FORM_LBL_PORTFOLIO_COMPLETED_DATE'); ?>:</label> <?php echo $this->item->completed_date;?></div>
				<?php }?>
			</article>
			</div>

		</div>
	</div>
	
	<?php
else:
	echo JText::_('COM_TLPPORTFOLIO_ITEM_NOT_LOADED');
endif;
