<?php
/**
 * JHTMLHelper for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         http://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

/**
 * Utility class for creating HTML Grids
 *
 * @static
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @since   1.5.5
 */
class JHTMLVisforms
{
    //array of loaded css and javascirpt files
    protected static $loaded = array();

   /**
     * Method to displays the credits in backend
     *
     * @return  void
     * @since   1.0.6
     */
    public static function creditsBackend()
    {
        $html = '<div class="row-fluid"><div class="visformbottom span11 well" style="text-align: center;margin-top:40px;">Visforms Version ' . self::getVersion() . ', &copy; 2012 - ' . self::getCopyRightDate() . ' by <a href="http://vi-solutions.de" target="_blank" class="smallgrey">vi-solutions</a>, all rights reserved. visForms is Free Software released under the <a href="http://www.gnu.org/licenses/gpl-2.0.html" target="_blank" class="smallgrey">GNU/GPL License</a>.</div></div>';
        return $html;
    }

    /**
     * Method to display credits in frontend
     *
     * @return  void
     *
     * @since   11.1
     */
    public static function creditsFrontend()
    {
        return '<div id="vispoweredby"><a href="http://vi-solutions.de" target="_blank">' . JText::_('COM_VISFORMS_POWERED_BY') . '</a></div>';
    }

    /**
     * Method to get the version number of installed version of visforms.
     *
     * @return  string  version number
     *
     * @since   11.1
     */
    public static function getVersion()
    {
        $xml_file = JPath::clean(JPATH_ADMINISTRATOR . '/components/com_visforms/visforms.xml');
        $installed_version = '1.0.0';
        if (file_exists($xml_file))
        {
            //supress warnings
            libxml_use_internal_errors(true);
            $xml = JFactory::getXML($xml_file);
            $installed_version = $xml->version;
        }
        return $installed_version;
    }

    public static function getFrontendDataEditVersion()
    {
        return VisformsAEF::getVersion(VisformsAEF::$allowfrontenddataedit);
    }

    public static function getPluginFormViewVersion()
    {
        return VisformsAEF::getVersion(VisformsAEF::$vfformview);
    }

    public static function checkMySubmissionsMenuItemExists()
    {
        //don't allow access to data edit view if there is not visforms data edit list menu item
        $app = JFactory::getApplication();
        $menuitems = $app->getMenu()->getItems('link', 'index.php?option=com_visforms&view=mysubmissions');
        if ((!(empty($menuitems))) && (is_array($menuitems)) && (!empty($menuitems[0]->id)))
        {
            return $menuitems[0]->id;
        }
        return false;
    }

    public static function getCopyRightDate()
    {
        $xml_file = JPath::clean(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_visforms' . DIRECTORY_SEPARATOR . 'visforms.xml');
        $crd = JHtml::_('date', 'now', 'Y');
        if (file_exists($xml_file))
        {
            //supress warnings
            libxml_use_internal_errors(true);
            $xml = JFactory::getXML($xml_file);
            $cdate = $xml->creationDate;
        }
        return $crd;
    }

    /**
     * Method to create html code for text "Required" according to form layout settings
     *
     * @param object $form form object
     *
     * @return string html code for text "Required"
     *
     * @since
     */
    public static function getRequired($form)
    {
        $html = array();
        switch ($form->formlayout)
        {
            case 'bthorizontal':
            case 'editbthorizontal' :
                $html[] = '<div class="control-group">';
                $html[] = '<label class="control-label vis_mandatory">' . JText::_('COM_VISFORMS_REQUIRED') . ' *</label>';
                $html[] = '</div>';
                break;
            case 'bt3horizontal':
            case 'editbt3horizontal':
                $html[] = '<div class="form-group">';
                $html[] = '<label class="control-label col-sm-3 vis_mandatory">' . JText::_('COM_VISFORMS_REQUIRED') . ' *</label>';
                $html[] = '</div>';
                break;
            default :
                $html[] = '<label class="vis_mandatory visCSSbot10 visCSStop10">' . JText::_('COM_VISFORMS_REQUIRED') . ' *</label>';
                break;
        }
        return implode('', $html);
    }

    /**
     * Method to create html code for tooltips when using ## as seperator between title and tiptext (backwards compatibility)
     *
     * @param   object $fields Object of form fields
     *
     * @return  string  html code for tooltip or field label
     *
     * @since   11.1
     */
    public static function createTip($field)
    {
        $tip = array();
        $html = "";

        //Show Helptext in Tooltip
        if (isset($field->custominfo) && $field->custominfo != "")
        {
            $tip = explode('##', $field->custominfo, 2);
        }

        if ($tip)
        {
            if (!isset($tip[1]))
            {
                //tip has no title seperated by ##
                $html = JHtml::_('tooltip', $tip[0], '', '', $field->label);
            }
            else
            {
                //tip has text and title
                $html = JHtml::_('tooltip', $tip[1], $tip[0], '', $field->label);
            }
        }
        else
        {
            //return field label as text
            $html = $field->label;
        }
        return $html;
    }

    /**
     * Method to create html code for captcha tooltips
     *
     * @param   object $form Visforms form object
     *
     * @return  string  html code for tooltip or field label
     *
     * @since   11.1
     */
    public static function createCaptchaTip($form)
    {
        $html = "";

        //Show Helptext in Tooltip
        $captchalabel = "Captcha";
        if (isset($form->captchalabel))
        {
            $captchalabel = $form->captchalabel;
        }
        if (isset($form->captchacustominfo) && ($form->captchacustominfo != ""))
        {
            $html = JHtml::_('tooltip', $form->captchacustominfo, '', '', $captchalabel);
        }
        else
        {
            $html = $captchalabel;
        }
        return $html;
    }

    /**
     * Method to create html code to generate the captcha
     *
     * @param   object $fields Object of form fields
     *
     * @return  string  html code for radio
     *
     * @since   11.1
     */
    public static function getCaptchaHtml($form, $clear = false)
    {
        $html = "";
        if (isset($form->captcha))
        {
            switch ($form->formlayout)
            {
                case "visforms" :
                case "edit" :
                    return self::getDefaultLayoutCaptchaHtml($form, $clear);
                case "btdefault" :
                case "editbtdefault" :
                    return self::getBtdefaultLayoutCaptchaHtml($form, $clear);
                case "bthorizontal" :
                case "editbthorizontal" :
                    return self::getBthorizontalLayoutCaptchaHtml($form, $clear);
                case "mcindividual" :
                case "editmcindividual" :
                    return self::getMcindividualLayoutCaptchaHtml($form, $clear);
                case "bt3default" :
                case "editbt3default" :
                    return self::getBt3defaultLayoutCaptchaHtml($form, $clear);
                case "bt3horizontal" :
                case "editbt3horizontal" :
                    return self::getBt3horizontalLayoutCaptchaHtml($form, $clear);
                case "bt3mcindividual" :
                case "editbt3mcindividual" :
                    return self::getBt3mcindividualLayoutCaptchaHtml($form, $clear);
                default :
                    break;
            }
        }
        return $html;
    }

    protected static function getDefaultLayoutCaptchaHtml($form, $clear = false)
    {
        $layout = new JLayoutFile('visforms.captcha.default', null);
        $layout->setOptions(array('component' => 'com_visforms'));
        $html = $layout->render(array('form' => $form, 'clear' => $clear));
        return $html;
    }

    protected static function getBtdefaultLayoutCaptchaHtml($form, $clear = false)
    {
        $layout = new JLayoutFile('visforms.captcha.btdefault', null);
        $layout->setOptions(array('component' => 'com_visforms'));
        $html = $layout->render(array('form' => $form, 'clear' => $clear));
        return $html;
    }

    protected static function getBthorizontalLayoutCaptchaHtml($form, $clear = false)
    {

        $layout = new JLayoutFile('visforms.captcha.bthorizontal', null);
        $layout->setOptions(array('component' => 'com_visforms'));
        $html = $layout->render(array('form' => $form, 'clear' => $clear));
        return $html;
    }

    protected static function getMcindividualLayoutCaptchaHtml($form, $clear = false)
    {
        $layout = new JLayoutFile('visforms.captcha.mcindividual', null);
        $layout->setOptions(array('component' => 'com_visforms'));
        $html = $layout->render(array('form' => $form, 'clear' => $clear));
        return $html;
    }

    protected static function getBt3defaultLayoutCaptchaHtml($form, $clear = false)
    {
        $layout = new JLayoutFile('visforms.captcha.bt3default', null);
        $layout->setOptions(array('component' => 'com_visforms'));
        $thtml = $layout->render(array('form' => $form, 'clear' => $clear));
        if (!empty($thtml))
        {
            return $thtml;
        }
        $html = array();
        if (isset($form->captcha))
        {
            //Create a div with the right class where we can put the validation errors into
            $html[] = '<div class="fc-tbxrecaptcha_response_field"></div>';
            //showcaptchalabe == 0: show label!
            $html[] = (!(isset($form->showcaptchalabel)) || ($form->showcaptchalabel == 0)) ? '<div class="required">' : '<div class="required asterix-ancor">';
            $html[] = '<div class="form-group">';
            $html[] = (!(isset($form->showcaptchalabel)) || ($form->showcaptchalabel == 0)) ? '<label id="captcha-lbl" for="recaptcha_response_field">' . self::createCaptchaTip($form) . '</label>' : '<span class ="asterix-ancor"></span>';
            if ($clear)
            {
                $html[] = '<div class="clr"> </div>';
            }
            switch ($form->captcha)
            {
                case 1 :
                    $html[] = '<img id="captchacode' . $form->id . '" class="captchacode" src="index.php?option=com_visforms&task=visforms.captcha&sid=c4ce9d9bffcf8ba3357da92fd49c2457&id=' . $form->id . '" align="absmiddle"> &nbsp; ';

                    $html[] = '<img alt="' . JText::_('COM_VISFORMS_REFRESH_CAPTCHA') . '" class="captcharefresh' . $form->id . '" src="' . JURI::root(true) . '/components/com_visforms/captcha/images/refresh.gif' . '" align="absmiddle"> &nbsp;';
                    $html[] = '<input class="" type="text" id="recaptcha_response_field" name="recaptcha_response_field" />';
                    break;
                case 2:
                    $captcha = JCaptcha::getInstance('recaptcha');
                    $html[] = $captcha->display(null, 'dynamic_recaptcha_1', 'required');
                    break;
                default :
                    return '';
            }
            $html[] = '</div>';
            $html[] = '</div>';
        }
        return implode('', $html);
    }

    protected static function getBt3horizontalLayoutCaptchaHtml($form, $clear = false)
    {
        $layout = new JLayoutFile('visforms.captcha.bt3horizontal', null);
        $layout->setOptions(array('component' => 'com_visforms'));
        $thtml = $layout->render(array('form' => $form, 'clear' => $clear));
        if (!empty($thtml))
        {
            return $thtml;
        }
        $html = array();
        if (isset($form->captcha))
        {
            $captchaHeight = ((!empty($form->viscaptchaoptions)) && (!empty($form->viscaptchaoptions['image_height'])) && (!($form->captcha == 2))) ? (int) $form->viscaptchaoptions['image_height'] : 0;
            $styleHeight = (!empty($captchaHeight)) ? 'style="height: '.$captchaHeight.'px; line-height: '.$captchaHeight.'px;" ' : '';
            //Create a div with the right class where we can put the validation errors into
            $html[] = '<div class="fc-tbxrecaptcha_response_field"></div>';
            $html[] = '<div class="form-group required">';
            //showcaptchalabe == 0: show label!
            $html[] = (!(isset($form->showcaptchalabel)) || ($form->showcaptchalabel == 0)) ? '<label class="col-sm-3 control-label" id="captcha-lbl" for="recaptcha_response_field" '.$styleHeight .'>' . self::createCaptchaTip($form) . '</label>' : '<span class="col-sm-3 control-label"></span>';
            $html[] = '<div class="col-sm-9">';
            switch ($form->captcha)
            {
                case 1 :
                    $html[] = '<img id="captchacode' . $form->id . '" class="captchacode" src="index.php?option=com_visforms&task=visforms.captcha&sid=c4ce9d9bffcf8ba3357da92fd49c2457&id=' . $form->id . '" align="absmiddle"> &nbsp; ';

                    $html[] = '<img alt="' . JText::_('COM_VISFORMS_REFRESH_CAPTCHA') . '" class="captcharefresh' . $form->id . '" src="' . JURI::root(true) . '/components/com_visforms/captcha/images/refresh.gif' . '" align="absmiddle"> &nbsp;';
                    $html[] = '<input class="visCSStop10" type="text" id="recaptcha_response_field" name="recaptcha_response_field" />';
                    break;
                case 2:
                    $captcha = JCaptcha::getInstance('recaptcha');
                    $html[] = $captcha->display(null, 'dynamic_recaptcha_1', 'required');
                    break;
                default :
                    return '';
            }
            $html[] = '</div>';
            $html[] = '</div>';
        }
        return implode('', $html);
    }

    protected static function getBt3mcindividualLayoutCaptchaHtml($form, $clear = false)
    {
        $layout = new JLayoutFile('visforms.captcha.bt3mcindividual', null);
        $layout->setOptions(array('component' => 'com_visforms'));
        $thtml = $layout->render(array('form' => $form, 'clear' => $clear));
        if (!empty($thtml))
        {
            return $thtml;
        }
        $html = array();
        if (isset($form->captcha))
        {
            $captchaHeight = ((!empty($form->viscaptchaoptions)) && (!empty($form->viscaptchaoptions['image_height'])) && (!($form->captcha == 2))) ? (int)$form->viscaptchaoptions['image_height'] : 0;
            $styleLabelHeight = (!empty($captchaHeight)) ? 'style="height: ' . $captchaHeight . 'px; line-height: ' . $captchaHeight . 'px;" ' : '';
            $paddingtop = (!empty($captchaHeight)) ? ($captchaHeight - 40)/2 : 0;
            $styleInputHeight = (!empty($captchaHeight)) ? 'style="height: ' . $captchaHeight . 'px;  padding-top: '. $paddingtop .'px;"' : '';

            $html[] = '<div class="row visCSSbot10">';
            $html[] = ($form->captcha == 2) ? '<div class="col-sm-12 required">': '<div class="col-sm-3 required">';
            $html[] = (!(isset($form->showcaptchalabel)) || ($form->showcaptchalabel == 0)) ? '<label ' . $styleLabelHeight . 'id="captcha-lbl" for="recaptcha_response_field">' . self::createCaptchaTip($form) . '</label>' : '<div class="form-group"><span class ="asterix-ancor"></span></div>';
            $html[] = '</div>';
            switch ($form->captcha)
            {
                case 1 :
                    $html[] = '<div class="col-sm-5">';
                    $html[] = '<img id="captchacode' . $form->id . '" class="captchacode" src="index.php?option=com_visforms&task=visforms.captcha&sid=c4ce9d9bffcf8ba3357da92fd49c2457&id=' . $form->id . '" align="absmiddle"> &nbsp; ';

                    $html[] = '<img alt="' . JText::_('COM_VISFORMS_REFRESH_CAPTCHA') . '" class="captcharefresh' . $form->id . '" src="' . JURI::root(true) . '/components/com_visforms/captcha/images/refresh.gif' . '" align="absmiddle"> &nbsp;';
                    $html[] = '</div><div class="col-sm-4" '. $styleInputHeight.'>';
                    $html[] = '<input class="form-control" type="text" id="recaptcha_response_field" name="recaptcha_response_field" />';
                    //Create a div with the right class where we can put the validation errors into
                    $html[] = '<div class="fc-tbxrecaptcha_response_field" style="position:absolute;bottom:100%;left:0;"></div>';
                    $html[] = '</div>';
                    break;
                case 2:
                    //Create a div with the right class where we can put the validation errors into
                    $html[] = '<div class="fc-tbxrecaptcha_response_field"></div>';
                    $captcha = JCaptcha::getInstance('recaptcha');
                    $html[] = $captcha->display(null, 'dynamic_recaptcha_1', 'col-sm-12 required');
                    break;
                default :
                    return '';
            }
            $html[] = '</div>';
        }
        return implode('', $html);
    }

    public static function getRestrictedId($restrict)
    {
        return preg_replace('/[^0-9]/', '', $restrict);
    }

    /**
     * Method to extract uploadfile Link from JRegistry Object and create link HTML
     * in earlier versions of visforms link information was not stored
     *
     *
     * @param   object $registryString JRegistry Object that contains link and file name information
     *
     * @return  string  ancor tag (HTML) or filename (if no link information is available)
     *
     * @since   11.1
     */
    public static function getUploadFileLink($registryString)
    {
        //info about uploaded files are stored in a JSON Object. Earlier versions just have a string.
        $registry = new JRegistry;
        $registry->loadString($registryString);
        $fileInfo = $registry->toArray();
        if (isset($fileInfo['folder']))
        {
            //return link
            return '<a href="' . JUri::root() . $fileInfo['folder'] . '/' . $fileInfo['file'] . '" target="_blank">' . JUri::root() . $fileInfo['folder'] . '/' . $fileInfo['file'] . '</a>';
        }
        else
        {
            return basename($registryString);
        }
    }

    /**
     * Method to extract upload filename from JRegistry Object
     *
     * @param   object $registryString JRegistry Object that contains link and file name information
     *
     * @return  string  filename
     *
     * @since   11.1
     */
    public static function getUploadFilePath($registryString)
    {
        //info about uploaded files are stored in a JSON Object. Earlier versions just have a string.
        $registry = new JRegistry;
        $registry->loadString($registryString);
        $fileInfo = $registry->toArray();
        if ((isset($fileInfo['file'])) && (isset($fileInfo['folder'])))
        {
            return $fileInfo['folder'] . '/' . $fileInfo['file'];
        }
        else
        {
            return basename($registryString);
        }
    }

    /**
     * Method to extract upload filename from JRegistry Object
     *
     * @param   object $registryString JRegistry Object that contains link and file name information
     *
     * @return  string  filename
     *
     * @since   11.1
     */
    public static function getUploadFileName($registryString)
    {
        //info about uploaded files are stored in a JSON Object. Earlier versions just have a string.
        $registry = new JRegistry;
        $registry->loadString($registryString);
        $fileInfo = $registry->toArray();
        if (isset($fileInfo['file']))
        {
            return $fileInfo['file'];
        }
        else
        {
            return basename($registryString);
        }
    }

    /**
     * Method to load visforms specific css and javascripts files; Load them only once
     *
     * @param   boolean $includeBootstrap include additonal CSS with Bootstrap form CSS if set to true
     *
     * @return  void
     *
     * @since   11.1
     */
    public static function includeScriptsOnlyOnce($cssScripts = array('visforms' => true, 'bootstrapform' => false), $jsScripts = array('validation' => true))
    {
        // Add css and js links
        $doc = JFactory::getDocument();
        if (!isset ($cssScripts['visforms.min']))
        {
            $cssScripts['visforms.min'] = true;
        }
        //include all css files with "custom" in filename
        $customCSS = self::getCustomCssFileNameList();
        $cssScripts = array_merge($cssScripts, $customCSS);
        //initialize some control vars
        foreach ($cssScripts as $scriptName => $scriptValue)
        {
            if (empty(static::$loaded['cssFile'][$scriptName]) && $scriptValue)
            {
                $doc->addStyleSheet(JURI::root(true) . '/media/com_visforms/css/' . $scriptName . '.css');
                static::$loaded['cssFile'][$scriptName] = true;
            }
        }

        if ($jsScripts['validation'] == true)
        {
            //we use addCustomTag to load jQuery library and depending scripts. If already included they are stored in this array
            JHtml::_('jquery.framework');
            JHtml::_('script', 'media/com_visforms/js/jquery.validate.min.js', false, false, false, false);
            JHtml::_('script', 'media/com_visforms/js/visforms.js', false, false, false, false);
            self::getValidatorMessagesScript();
            self::getValidatorMethodsScript();
        }
    }

    public static function getValidatorMessagesScript ()
    {
        if (!empty(static::$loaded[__METHOD__]))
        {
            return;
        }
        $script = 'jQuery(document).ready(function () {
            jQuery.extend(jQuery.validator.messages, {
            required: "' . addslashes(JText::_('COM_VISFORMS_ENTER_REQUIRED')). '",
            remote: "Please fix this field.",
            email: "' . addslashes(JText::_('COM_VISFORMS_ENTER_VALID_EMAIL')) .'",
            url: "' . addslashes(JText::_('COM_VISFORMS_ENTER_VALID_URL')) . '",
            date: "' . addslashes(JText::_('COM_VISFORMS_ENTER_VALID_DATE')) . '",
            dateISO: "Please enter a valid date (ISO).",
            number: "' . addslashes(JText::_('COM_VISFORMS_ENTER_VALID_NUMBER')) . '",
            digits: "' . addslashes(JText::_('COM_VISMORMS_ENTER_VALID_DIGIT')) . '",
            creditcard: "Please enter a valid credit card number.",
            equalTo: "'. addslashes(JText::_('COM_VISFORMS_ENTER_CONFIRM')) . '",
            maxlength: jQuery.validator.format("' . addslashes(JText::_('COM_VISFORMS_ENTER_VAILD_MAXLENGTH')) . '"),
            minlength: jQuery.validator.format("' . addslashes(JText::_('COM_VISFORMS_ENTER_VAILD_MINLENGTH')) . '"),
            rangelength: jQuery.validator.format("' . addslashes(JText::_('COM_VISMORMS_ENTER_VAILD_LENGTH')) . '"),
            range: jQuery.validator.format("' . addslashes(JText::_('COM_VISFORMS_ENTER_VAILD_RANGE')) . '"),
            max: jQuery.validator.format("' . addslashes(JText::_('COM_VISFORMS_ENTER_VAILD_MAX_VALUE')) . '"),
            min: jQuery.validator.format("' . addslashes(JText::_('COM_VISFORMS_ENTER_VAILD_MIN_VALUE')) . '"),
            customvalidation: "' . addslashes(JText::_('COM_VISFORMS_INVALID_INPUT')) . '"
            });
            });';
        JFactory::getDocument()->addScriptDeclaration($script);
        static::$loaded[__METHOD__] = true;
    }

    public static function getValidatorMethodsScript()
    {
        if (!empty(static::$loaded[__METHOD__]))
        {
            return;
        }
        $script = 'jQuery(document).ready(function () {
            jQuery.validator.addMethod("dateDMY", function (value, element) {
                var check = false;
                var re = /^(0[1-9]|[12][0-9]|3[01])[\.](0[1-9]|1[012])[\.]\d{4}$/;
                    if (re.test(value)) {
                        var adata = value.split(".");
                        var day = parseInt(adata[0], 10);
                        var month = parseInt(adata[1], 10);
                        var year = parseInt(adata[2], 10);
                        if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
                            check = false; // 31st of a month with 30 days
                        } else if (day >= 30 && month == 2) {
                            check = false; // February 30th or 31st
                        } else if (month == 2 && day == 29 && !(year % 4 == 0 && (year % 100 != 0 || year % 400 == 0))) {
                            check = false; // February 29th outside a leap year
                        } else {
                            check = true; // Valid date
                        }
                    }
                    return this.optional(element) || check;
            });
            jQuery.validator.addMethod("dateMDY", function (value, element) {
                var check = false;
                var re = /^(0[1-9]|1[012])[\/](0[1-9]|[12][0-9]|3[01])[\/]\d{4}$/;
                    if (re.test(value)) {
                        var adata = value.split("/");
                        var month = parseInt(adata[0], 10);
                        var day = parseInt(adata[1], 10);
                        var year = parseInt(adata[2], 10);
                        if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
                            check = false; // 31st of a month with 30 days
                        } else if (day >= 30 && month == 2) {
                            check = false; // February 30th or 31st
                        } else if (month == 2 && day == 29 && !(year % 4 == 0 && (year % 100 != 0 || year % 400 == 0))) {
                            check = false; // February 29th outside a leap year
                        } else {
                            check = true; // Valid date
                        }
                    }
                    return this.optional(element) || check;
            });
            jQuery.validator.addMethod("dateYMD", function (value, element) {
                var check = false;
                var re = /^\d{4}[\-](0[1-9]|1[012])[\-](0[1-9]|[12][0-9]|3[01])$/;
                    if (re.test(value)) {
                        var adata = value.split("-");
                        var year = parseInt(adata[0], 10);
                        var month = parseInt(adata[1], 10);
                        var day = parseInt(adata[2], 10);
                        if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
                            check = false; // 31st of a month with 30 days
                        } else if (day >= 30 && month == 2) {
                            check = false; // February 30th or 31st
                        } else if (month == 2 && day == 29 && !(year % 4 == 0 && (year % 100 != 0 || year % 400 == 0))) {
                            check = false; // February 29th outside a leap year
                        } else {
                            check = true; // Valid date
                        }
                    }
                    return this.optional(element) || check;
            });
            jQuery.validator.addMethod("filesize", function (value, element, maxsize) {
                var check = false;
                if ((maxsize === 0) || ((!(element.files.length == 0)) && (element.files[0].size < maxsize)))
                {
                    check = true;
                }
                return this.optional(element) || check;
            });
            jQuery.validator.addMethod("fileextension", function (value, element, allowedextension) {
                var check = false;
                allowedextension = allowedextension.replace(/\s/g, "");
                allowedextension = allowedextension.split(",");
                var fileext = jQuery(element).val().split(".").pop().toLowerCase();
                if (jQuery.inArray(fileext, allowedextension) > -1)
                {
                    check = true;
                }
                return this.optional(element) || check;
            });
            jQuery.validator.addMethod("customvalidation", function (value, element, re) {
                return this.optional(element) || re.test(value);
            });
        });';
        JFactory::getDocument()->addScriptDeclaration($script);
        static::$loaded[__METHOD__] = true;
    }

    public static function replacePlaceholder($form, &$text = '')
    {
        $fieldValue = ' ';

        if ($text != '')
        {
            //enclose pattern in '' and // as delimeter
            $pattern = '/\[[A-Z0-9]{1}[A-Z0-9\-]*]/';
            if (preg_match_all($pattern, $text, $matches))
            {
                //found matches are store in the $matches[0] array
                $isEdit = ((!empty($form->context)) && (strpos($form->context, 'vfedit') !== false)) ? true : false;
                foreach ($matches[0] as $match)
                {
                    $str = trim($match, '\[]');
                    $field = $form->context . JString::strtolower($str);
                    $fieldValue = " ";
                    if (isset($field) && ($field != "") && (is_array($form->fields)))
                    {
                        foreach ($form->fields as $ffield)
                        {
                            //Match is a real form field
                            if ($field == $ffield->name)
                            {
                                //get field type
                                $fieldtype = $ffield->typefield;
                                //we use the fieldtype to distinguish between upload fields and the rest which can be captured from $field->dbValue
                                if (($fieldtype == "file") && (empty($ffield->isDisabled)))
                                {
                                    $deleteFlagId = $field . '-filedelete';
                                    $deleteFlagValue = JFactory::getApplication()->input->get($deleteFlagId);
                                    if (isset($form->emailrecipientincfilepath) && ($form->emailrecipientincfilepath == true) &&
                                    (isset($ffield->file['filelink']) || (!empty($isEdit) && isset($ffield->orgfile) && isset($ffield->orgfile->filelink))))
                                    {

                                        if (isset($ffield->file['filelink']))
                                        {
                                            $fieldValue = $ffield->file['filelink'];
                                        }
                                        else if (!empty($isEdit) && isset($ffield->orgfile) && isset($ffield->orgfile->filelink) && empty($deleteFlagValue))
                                        {
                                            $fieldValue = $ffield->orgfile->filelink;
                                        }
                                    }
                                    else
                                    {
                                        if (isset($_FILES[$ffield->name]['name']) && $_FILES[$ffield->name]['name'] != '')
                                        {
                                            $fieldValue = $_FILES[$ffield->name]['name'];
                                        }
                                        else if (isset($ffield->orgfile) && isset($ffield->orgfile->name) && !empty($ffield->orgfile->name) && empty($deleteFlagValue))
                                        {
                                            $fieldValue = $ffield->orgfile->name;
                                        }
                                    }
                                }
                                else
                                {
                                    if (isset($ffield->dbValue))
                                    {
                                        $fieldValue = $ffield->dbValue;
                                    }
                                    else
                                    {
                                        //fallback (i.e. calculation with no equation)
                                        $fieldValue = "";
                                    }
                                }
                                if (in_array($fieldtype, array("multicheckbox", "select", "radio")))
                                {
                                    $fieldValue = implode(', ', JHtmlVisformsselect::mapDbValueToOptionLabel($fieldValue, $ffield->list_hidden));
                                }
                            }
                        }
                    }

                    //replace the match
                    $newText = preg_replace('\'' . preg_quote($match) . '\'', $fieldValue, $text);
                    $text = $newText;
                }
            }
        }
        return $text;
    }

    public static function fixLinksInMail(&$text)
    {
        $urlPattern = '/^(http|https|ftp|mailto)\:.*$/i';
        $aPattern = '/<[ ]*a[^>]+href=[("\')]([^("\')]*)/';
        $imgPattern = '/<[ ]*img[^>]+src=[("\')]([^("\')]*)/';
        if (preg_match_all($aPattern, $text, $hrefs))
        {
            foreach ($hrefs[1] as $href)
            {
                if (!(preg_match($urlPattern, $href) == 1))
                {
                    //we deal with an intern Url without Root path
                    $link = JURI::base() . $href;
                    $newText = preg_replace('\'' . preg_quote($href) . '\'', $link, $text);
                    $text = $newText;
                }
            }
        }
        if (preg_match_all($imgPattern, $text, $srcs))
        {
            jimport('joomla.filesystem.file');
            jimport('joomla.filesystem.folder');
            foreach ($srcs[1] as $src)
            {
                if (JFile::exists($src))
                {
                    //we deal with a local img
                    if (!(preg_match('\'' . preg_quote(Juri::base()) . '\'', $src) == 1))
                    {
                        //we deal with an intern Url without base Uri
                        $link = Juri::base() . $src;
                        $newText = preg_replace('\'' . preg_quote($src) . '\'', $link, $text);
                        $text = $newText;
                    }
                }
            }
        }

        return $text;
    }

    /**
     * Method to sort a column in a grid
     *
     * @param   string $title The link title
     * @param   string $order The order field for the column
     * @param   string $direction The current direction
     * @param   string $selected The selected ordering
     * @param   string $task An optional task override
     * @param   string $new_direction An optional direction for the new column
     * @param   string $tip An optional text shown as tooltip title instead of $title
     *
     * @return  string
     *
     * @since   1.5
     */
    //this is a copy of JHtml::_(gird.sort...
    //necessary to use our own function because we cannot change the icon prefix in Joomla! grid.sort function into visicon
    //and to allow multipe sort forms on one page (since Visforms 3.7.1)
    public static function sort($title, $order, $direction = 'asc', $selected = '', $task = null, $new_direction = 'asc', $tip = '', $form = 'adminForm', $jsFunction = "Joomla.tableOrdering")
    {
        JHtml::_('behavior.core');
        JHtml::_('bootstrap.tooltip');

        $direction = strtolower($direction);
        $icon = array('arrow-up-3', 'arrow-down-3');
        $index = (int)($direction == 'desc');

        if ($order != $selected)
        {
            $direction = $new_direction;
        }
        else
        {
            $direction = ($direction == 'desc') ? 'asc' : 'desc';
        }
        $html = array();
        $html[] = '<a href="#" onclick="' . $jsFunction . '(\'' . $order . '\',\'' . $direction . '\',\'' . $task . '\',document.getElementById(\'' . $form . '\'));return false;"'
            . ' class="hasTooltip" title="' . JHtml::tooltipText(($tip ? $tip : $title), 'JGLOBAL_CLICK_TO_SORT_THIS_COLUMN') . '">';

        if (isset($title['0']) && $title['0'] == '<')
        {
            $html[] = $title;
        }
        else
        {
            $html[] = JText::_($title);
        }

        if ($order == $selected)
        {
            $html[] = ' <span class="visicon-' . $icon[$index] . '"></span>';
        }

        $html[] = '</a>';

        return implode('', $html);
    }

    private static function getCustomCssFileNameList()
    {
        jimport('joomla.filesystem.folder');
        $path = JPath::clean(JPATH_ROOT . '/media/com_visforms/css/');
        $result = array();
        $dirFiles = scandir($path);
        $regex = '@^(.*custom.*)(\.css)$@';

        foreach ($dirFiles as $key => $value)
        {
            if (is_file(JPath::clean($path . $value)))
            {
                if (preg_match($regex, $value, $match))
                {
                    if ($match)
                    {
                        $match = preg_replace($regex, '$1', $value);
                        $result[$match] = true;
                    }
                }
            }
        }
        return $result;
    }

    public static function base64_url_encode($val)
    {
        return strtr(base64_encode($val), '+/=', '-_,');
    }

    static function base64_url_decode($val)
    {
        return base64_decode(strtr($val, '-_,', '+/='));
    }

    public static function createSelectFromDb($table, $name, $selected, $attribs = '', $params = true, $id = false, $textfieldname = "a.title", $where='', $order = '', $textprefix = '', $valueprefix = '', $requiresSub = true)
    {
        $hasSub = VisformsAEF::checkAEF(VisformsAEF::$subscription);
        if (empty($requiresSub) || (!empty($hasSub)))
        {
            $db = JFactory::getDbo();;
            $query = $db->getQuery(true);
            $query->select($db->quoteName('a.id', 'value') . ', ' . $db->quoteName($textfieldname, 'text'))
                ->from($db->quoteName($table, 'a'));
            if (!empty($where))
            {
                $query->where($where);
            }
            if (!empty($order))
            {
                $query->order($db->quoteName($order) . ' DESC');
            }
            // Get the options.
            $db->setQuery($query);
            try
            {
                $options = $db->loadObjectList();
            }
            catch (RuntimeException $e)
            {
                $options = array();
            }
            if (!empty($options))
            {
                $count = count($options);
                for ($i = 0; $i < $count; $i++)
                {
                    if (!empty($valueprefix))
                    {
                        $options[$i]->value = JText::_($valueprefix) . $options[$i]->value;
                    }
                    if (!empty($textprefix))
                    {
                        $options[$i]->text = JText::_($textprefix) . ': ' . $options[$i]->text;
                    }
                }
            }
        }
        else
        {
            $options = array();
        }

        // If params is an array, push these options to the array
        if (is_array($params))
        {
            $options = array_merge($params, $options);
        }

        return JHtml::_(
            'select.genericlist',
            $options,
            $name,
            array(
                'list.attr' => $attribs,
                'list.select' => $selected,
                'id' => $id
            )
        );
    }

    public static function getCustomUserFieldValue($id)
    {
        if (empty($id))
        {
            return false;
        }
        $user = JFactory::getUser();
        $userId = $user->get('id');
        if (empty($userId))
        {
            return false;
        }
        $db = JFactory::getDbo();;
        $query = $db->getQuery(true);
        $query->select($db->qn('value'))
            ->from($db->qn('#__fields_values'))
            ->where($db->qn('field_id') . ' = ' . $id)
            ->where($db->qn('item_id') . ' = ' . $userId);
        $db->setQuery($query);
        try
        {
            $value = $db->loadResult();
        }
        catch (RuntimeException $e)
        {
            $value = false;
        }
        return $value;
    }
}

?>